/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;

public class ArmorFeatheriteModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> FEATHER = TConstruct.createKey((String)"featherite_armor");

    public ArmorFeatheriteModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorFeatheriteModifier::onApplyEffect);
        MinecraftForge.EVENT_BUS.addListener(ArmorFeatheriteModifier::onUpdateApply);
        MinecraftForge.EVENT_BUS.addListener(ArmorFeatheriteModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(FEATHER, false, null));
    }

    private static void onApplyEffect(MobEffectEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(FEATHER, (Object)0);
            if (level > 0 && living instanceof ServerPlayer && event.getEffectInstance() != null && event.getEffectInstance().m_19544_() == MobEffects.f_19620_ && UpgradedNetheriteConfig.EnableLevitationImmune) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        });
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && living.m_6084_()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int level = (Integer)holder.get(FEATHER, (Object)0);
                if (level > 0 && living instanceof Player) {
                    Level world;
                    Player player = (Player)living;
                    if (UpgradedNetheriteConfig.EnableWaterLavaWalking && ((world = player.m_9236_()).m_6425_(player.m_20097_()).m_205070_(FluidTags.f_13132_) && !player.m_6047_() || world.m_6425_(player.m_20097_()).m_205070_(FluidTags.f_13131_) && !player.m_6047_() && !player.m_6069_())) {
                        if (player.m_20184_().m_7098_() < 0.0 && !player.m_20077_() && !player.m_20069_()) {
                            player.f_19789_ = 0.0f;
                            player.m_6853_(true);
                            player.m_20256_(player.m_20184_().m_82520_(0.0, -player.m_20184_().m_7098_(), 0.0));
                        } else if (player.m_20184_().f_82480_ < 0.15 && !player.m_204029_(FluidTags.f_13132_) && !player.m_204029_(FluidTags.f_13131_)) {
                            player.m_20256_(player.m_20184_().m_82520_(0.0, 0.15 - player.m_20184_().f_82480_, 0.0));
                        }
                    }
                }
            });
        }
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(FEATHER, (Object)0);
            if (level > 0 && event.getSource().m_146707_()) {
                event.setAmount(event.getAmount() * 0.5f);
            }
        });
    }
}

